//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Net;
using System.Net.Sockets;

namespace DNSUtilities
{
	/// <summary>
	/// Podsumowanie dla Class1.
	/// </summary>

        // IDictionaryEnumerator myEnumerator = myList.GetEnumerator();
        // Console.WriteLine( "\t-KEY-\t-VALUE-" );
        // while ( myEnumerator.MoveNext() )
        //    Console.WriteLine( "\t{0}:\t{1}", myEnumerator.Key, myEnumerator.Value );
        // Console.WriteLine();

	class DNSIPAddress
	{
		static void Main(string[] args)
		{
			String strHostName;
			if (args.Length == 0)
			{
				// Uzyskanie adresu IP komputera lokalnego.
				// Majpierw naley pobra nazw hosta.
				strHostName = Dns.GetHostName ();
				Console.WriteLine ("Nazwa hosta komputera lokalnego: " +  strHostName);
			}
			else
			{
				strHostName = args[0];
			}
          
			IPHostEntry ipEntry;
			IPAddress [] addr;
			try
			{
				// Wykorzystujc nazw hosta mona uzyska list adresw IP.
				ipEntry = Dns.GetHostByName (strHostName);
				addr = ipEntry.AddressList;
				for (int i = 0; i < addr.Length; i++)
				{
					Console.WriteLine ("IP Address {0}: {1} ", i, addr[i].ToString ());
				}
			}
			catch(SocketException e)
			{
				Console.WriteLine("Wujtek SocketException: {0}", e.Message);
			}
			catch(ArgumentNullException e)
			{
				Console.WriteLine("Wyjtek ArgumentNullException: {0}", e.Message);
			}
         
			return;
		}
	}		
}
